[comment {-*- tcl -*- doctools manpage}]
[manpage_begin tcl::chan::random n 1.1]
[keywords /dev/random]
[keywords random]
[keywords {reflected channel}]
[keywords {tip 219}]
[keywords {virtual channel}]
[copyright {2009 Andreas Kupries <andreas_kupries@users.sourceforge.net>}]
[moddesc   {Reflected/virtual channel support}]
[category  Channels]
[titledesc {Random channel}]
[require Tcl "8.5 9"]
[require TclOO]
[require tcl::chan::events [opt 1.1]]
[require tcl::chan::random [opt 1.1]]
[description]
[para]

The [package tcl::chan::random] package provides a command creating
random channels, i.e. read-only channels which return an infinite
stream of pseudo-random characters upon reading. This is similar to
the random channels provided by the package [package Memchan], except
that this is written in pure Tcl, not C, and uses a much simpler
generator as well. On the other hand, [package Memchan] is usable with
Tcl 8.4 and before, whereas this package requires Tcl 8.5 or higher,
and TclOO.

[para] The internal [package TclOO] class implementing the channel
handler is a sub-class of the [package tcl::chan::events] framework.

[section API]

[list_begin definitions]

[call [cmd ::tcl::chan::random] [arg seed]]

This command creates a new random channel and returns its handle.

The seed is a list of integer numbers used to initialize the
internal feedback shift register of the generator.

[list_end]

[vset CATEGORY virtchannel]
[include ../common-text/feedback.inc]
[manpage_end]
