[comment {-*- mode: tcl ; fill-column: 80 -*- doctools manpage}]
[vset PACKAGE_VERSION 0.14]
[manpage_begin tar n [vset PACKAGE_VERSION]]
[keywords archive]
[keywords {tape archive}]
[keywords tar]
[moddesc   {Tar file handling}]
[titledesc {Tar file creation, extraction & manipulation}]
[category  {File formats}]
[require Tcl "8.5 9"]
[require tar [opt [vset PACKAGE_VERSION]]]
[description]

[para] [strong Note]: Starting with version 0.8 the tar reader commands
(contents, stats, get, untar) support the GNU LongName extension (header type
'L') for large paths.

[para]

[section BEWARE]

For all commands, when using [option -chan] ...

[list_begin enumerated]

[enum] It is assumed that the channel was opened for reading, and configured for
       binary input.

[enum] It is assumed that the channel position is at the beginning of a legal
       tar file.

[enum] The commands will [emph modify] the channel position as they perform their
       task.

[enum] The commands will [emph not] close the channel.

[enum] In other words, the commands leave the channel in a state very likely
       unsuitable for use by further [cmd tar] commands. Still doing so will
       very likely results in errors, bad data, etc. pp.

[enum] It is the responsibility of the user to seek the channel back to a
       suitable position.

[enum] When using a channel transformation which is not generally seekable, for
       example [cmd gunzip], then it is the responsibility of the user to (a)
       unstack the transformation before seeking the channel back to a suitable
       position, and (b) for restacking it after.

[list_end]

Regarding support for gzip compression:

[list_begin enumerated]

[enum] Errors are thrown when attempting to read from compressed tar archives
       while compression support (i.e. [cmd ::zlib]) is not available.

[enum] Errors are thrown when attempting to read an uncompressed tar archive
       when compression is requested by the user ([option -gzip]).

[para] No errors are thrown when attempting to read a compressed tar archive
       when compression was not requested, and is supported. In that case the
       commands automatically activate the code handling the compression.

[enum] Errors are thrown when attempting to edit compressed tar archives.
       See the commands [cmd tar::add], and [cmd tar::remove].
       This is not supported.

[enum] Creation of compressed tar archives however is supported, as this
       sequentially writes the archive, allowing for streaming compression.

[list_end]

[section COMMANDS]

[list_begin definitions]

[call [cmd ::tar::contents] [arg tarball] [opt [option -chan]] [opt [option -gzip]]]

Returns a list of the files contained in [arg tarball]. The order is not sorted and depends on the order
files were stored in the archive.
[para]

If the option [option -chan] is present [arg tarball] is interpreted as an open channel.
It is assumed that the channel was opened for reading, and configured for binary input.
The command will [emph not] close the channel.

[call [cmd ::tar::stat] [arg tarball] [opt file] [opt [option -chan]] [opt [option -gzip]]]

Returns a nested dict containing information on the named [opt file] in [arg tarball],
or all files if none is specified. The top level are pairs of filename and info. The info is a dict with the keys
"[const mode] [const uid] [const gid] [const size] [const mtime] [const type] [const linkname] [const uname] [const gname]
 [const devmajor] [const devminor]"

[example {
% ::tar::stat tarball.tar
foo.jpg {mode 0644 uid 1000 gid 0 size 7580 mtime 811903867 type file linkname {} uname user gname wheel devmajor 0 devminor 0}
}]

[para]
If the option [option -chan] is present [arg tarball] is interpreted as an open channel.
It is assumed that the channel was opened for reading, and configured for binary input.
The command will [emph not] close the channel.

[call [cmd ::tar::untar] [arg tarball] [arg args]]

Extracts [arg tarball]. [arg -file] and [arg -glob] limit the extraction
to files which exactly match or pattern match the given argument. No error is
thrown if no files match. Returns a list of filenames extracted and the file
size. The size will be null for non regular files. Leading path seperators are
stripped so paths will always be relative.

[list_begin options]
[opt_def -dir dirName]
Directory to extract to. Uses [cmd pwd] if none is specified
[opt_def -file fileName]
Only extract the file with this name. The name is matched against the complete path
stored in the archive including directories.
[opt_def -glob pattern]
Only extract files patching this glob style pattern. The pattern is matched against the complete path
stored in the archive.
[opt_def -nooverwrite]
Dont overwrite files that already exist
[opt_def -nomtime]
Leave the file modification time as the current time instead of setting it to the value in the archive.
[opt_def -noperms]
In Unix, leave the file permissions as the current umask instead of setting them to the values in the archive.

[opt_def -chan]
If this option is present [arg tarball] is interpreted as an open channel.
It is assumed that the channel was opened for reading, and configured for binary input.
The command will [emph not] close the channel.

[list_end]
[para]

[example {
% foreach {file size} [::tar::untar tarball.tar -glob *.jpg] {
puts "Extracted $file ($size bytes)"
}
}]

[call [cmd ::tar::get] [arg tarball] [arg fileName] [opt [option -chan]] [opt [option -gzip]]]

Returns the contents of [arg fileName] from the [arg tarball].

[para][example {
% set readme [::tar::get tarball.tar doc/README] {
% puts $readme
}
}]

[para] If the option [option -chan] is present [arg tarball] is
interpreted as an open channel.  It is assumed that the channel was
opened for reading, and configured for binary input.  The command will
[emph not] close the channel.

[para] An error is thrown when [arg fileName] is not found in the tar
archive.

[call [cmd ::tar::create] [arg tarball] [arg files] [arg args]]

Creates a new tar file containing the [arg files]. [arg files] must be specified
as a single argument which is a proper list of filenames.

[list_begin options]
[opt_def -dereference]
Normally [cmd create] will store links as an actual link pointing at a file that may
or may not exist in the archive. Specifying this option will cause the actual file point to
 by the link to be stored instead.

[opt_def -chan]
If this option is present [arg tarball] is interpreted as an open channel.
It is assumed that the channel was opened for writing, and configured for binary output.
The command will [emph not] close the channel.

[list_end]
[para]

[example {
% ::tar::create new.tar [glob -nocomplain file*]
% ::tar::contents new.tar
file1 file2 file3
}]

[call [cmd ::tar::add] [arg tarball] [arg files] [arg args]]

Appends [arg files] to the end of the existing [arg tarball]. [arg files] must be specified
as a single argument which is a proper list of filenames.

[list_begin options]
[opt_def -dereference]
Normally [cmd add] will store links as an actual link pointing at a file that may
or may not exist in the archive. Specifying this option will cause the actual file point to
 by the link to be stored instead.
[opt_def -prefix string]
Normally [cmd add] will store files under exactly the name specified as
argument. Specifying a [opt -prefix] causes the [arg string] to be
prepended to every name.
[opt_def -quick]
The only sure way to find the position in the [arg tarball] where new
files can be added is to read it from start, but if [arg tarball] was
written with a "blocksize" of 1 (as this package does) then one can
alternatively find this position by seeking from the end. The
[opt -quick] option tells [cmd add] to do the latter.
[list_end]
[para]

[call [cmd ::tar::remove] [arg tarball] [arg files]]

Removes [arg files] from the [arg tarball]. No error will result if the file does not exist in the
tarball. Directory write permission and free disk space equivalent to at least the size of the tarball
will be needed.

[example {
% ::tar::remove new.tar {file2 file3}
% ::tar::contents new.tar
file3
}]

[list_end]

[vset CATEGORY tar]
[include ../common-text/feedback.inc]
[manpage_end]
