'\"
'\" Generated from file 'tar\&.man' by tcllib/doctools with format 'nroff'
'\"
.TH "tar" n 0\&.14 tcllib "Tar file handling"
.\" The -*- nroff -*- definitions below are for supplemental macros used
.\" in Tcl/Tk manual entries.
.\"
.\" .AP type name in/out ?indent?
.\"	Start paragraph describing an argument to a library procedure.
.\"	type is type of argument (int, etc.), in/out is either "in", "out",
.\"	or "in/out" to describe whether procedure reads or modifies arg,
.\"	and indent is equivalent to second arg of .IP (shouldn't ever be
.\"	needed;  use .AS below instead)
.\"
.\" .AS ?type? ?name?
.\"	Give maximum sizes of arguments for setting tab stops.  Type and
.\"	name are examples of largest possible arguments that will be passed
.\"	to .AP later.  If args are omitted, default tab stops are used.
.\"
.\" .BS
.\"	Start box enclosure.  From here until next .BE, everything will be
.\"	enclosed in one large box.
.\"
.\" .BE
.\"	End of box enclosure.
.\"
.\" .CS
.\"	Begin code excerpt.
.\"
.\" .CE
.\"	End code excerpt.
.\"
.\" .VS ?version? ?br?
.\"	Begin vertical sidebar, for use in marking newly-changed parts
.\"	of man pages.  The first argument is ignored and used for recording
.\"	the version when the .VS was added, so that the sidebars can be
.\"	found and removed when they reach a certain age.  If another argument
.\"	is present, then a line break is forced before starting the sidebar.
.\"
.\" .VE
.\"	End of vertical sidebar.
.\"
.\" .DS
.\"	Begin an indented unfilled display.
.\"
.\" .DE
.\"	End of indented unfilled display.
.\"
.\" .SO ?manpage?
.\"	Start of list of standard options for a Tk widget. The manpage
.\"	argument defines where to look up the standard options; if
.\"	omitted, defaults to "options". The options follow on successive
.\"	lines, in three columns separated by tabs.
.\"
.\" .SE
.\"	End of list of standard options for a Tk widget.
.\"
.\" .OP cmdName dbName dbClass
.\"	Start of description of a specific option.  cmdName gives the
.\"	option's name as specified in the class command, dbName gives
.\"	the option's name in the option database, and dbClass gives
.\"	the option's class in the option database.
.\"
.\" .UL arg1 arg2
.\"	Print arg1 underlined, then print arg2 normally.
.\"
.\" .QW arg1 ?arg2?
.\"	Print arg1 in quotes, then arg2 normally (for trailing punctuation).
.\"
.\" .PQ arg1 ?arg2?
.\"	Print an open parenthesis, arg1 in quotes, then arg2 normally
.\"	(for trailing punctuation) and then a closing parenthesis.
.\"
.\"	# Set up traps and other miscellaneous stuff for Tcl/Tk man pages.
.if t .wh -1.3i ^B
.nr ^l \n(.l
.ad b
.\"	# Start an argument description
.de AP
.ie !"\\$4"" .TP \\$4
.el \{\
.   ie !"\\$2"" .TP \\n()Cu
.   el          .TP 15
.\}
.ta \\n()Au \\n()Bu
.ie !"\\$3"" \{\
\&\\$1 \\fI\\$2\\fP (\\$3)
.\".b
.\}
.el \{\
.br
.ie !"\\$2"" \{\
\&\\$1	\\fI\\$2\\fP
.\}
.el \{\
\&\\fI\\$1\\fP
.\}
.\}
..
.\"	# define tabbing values for .AP
.de AS
.nr )A 10n
.if !"\\$1"" .nr )A \\w'\\$1'u+3n
.nr )B \\n()Au+15n
.\"
.if !"\\$2"" .nr )B \\w'\\$2'u+\\n()Au+3n
.nr )C \\n()Bu+\\w'(in/out)'u+2n
..
.AS Tcl_Interp Tcl_CreateInterp in/out
.\"	# BS - start boxed text
.\"	# ^y = starting y location
.\"	# ^b = 1
.de BS
.br
.mk ^y
.nr ^b 1u
.if n .nf
.if n .ti 0
.if n \l'\\n(.lu\(ul'
.if n .fi
..
.\"	# BE - end boxed text (draw box now)
.de BE
.nf
.ti 0
.mk ^t
.ie n \l'\\n(^lu\(ul'
.el \{\
.\"	Draw four-sided box normally, but don't draw top of
.\"	box if the box started on an earlier page.
.ie !\\n(^b-1 \{\
\h'-1.5n'\L'|\\n(^yu-1v'\l'\\n(^lu+3n\(ul'\L'\\n(^tu+1v-\\n(^yu'\l'|0u-1.5n\(ul'
.\}
.el \}\
\h'-1.5n'\L'|\\n(^yu-1v'\h'\\n(^lu+3n'\L'\\n(^tu+1v-\\n(^yu'\l'|0u-1.5n\(ul'
.\}
.\}
.fi
.br
.nr ^b 0
..
.\"	# VS - start vertical sidebar
.\"	# ^Y = starting y location
.\"	# ^v = 1 (for troff;  for nroff this doesn't matter)
.de VS
.if !"\\$2"" .br
.mk ^Y
.ie n 'mc \s12\(br\s0
.el .nr ^v 1u
..
.\"	# VE - end of vertical sidebar
.de VE
.ie n 'mc
.el \{\
.ev 2
.nf
.ti 0
.mk ^t
\h'|\\n(^lu+3n'\L'|\\n(^Yu-1v\(bv'\v'\\n(^tu+1v-\\n(^Yu'\h'-|\\n(^lu+3n'
.sp -1
.fi
.ev
.\}
.nr ^v 0
..
.\"	# Special macro to handle page bottom:  finish off current
.\"	# box/sidebar if in box/sidebar mode, then invoked standard
.\"	# page bottom macro.
.de ^B
.ev 2
'ti 0
'nf
.mk ^t
.if \\n(^b \{\
.\"	Draw three-sided box if this is the box's first page,
.\"	draw two sides but no top otherwise.
.ie !\\n(^b-1 \h'-1.5n'\L'|\\n(^yu-1v'\l'\\n(^lu+3n\(ul'\L'\\n(^tu+1v-\\n(^yu'\h'|0u'\c
.el \h'-1.5n'\L'|\\n(^yu-1v'\h'\\n(^lu+3n'\L'\\n(^tu+1v-\\n(^yu'\h'|0u'\c
.\}
.if \\n(^v \{\
.nr ^x \\n(^tu+1v-\\n(^Yu
\kx\h'-\\nxu'\h'|\\n(^lu+3n'\ky\L'-\\n(^xu'\v'\\n(^xu'\h'|0u'\c
.\}
.bp
'fi
.ev
.if \\n(^b \{\
.mk ^y
.nr ^b 2
.\}
.if \\n(^v \{\
.mk ^Y
.\}
..
.\"	# DS - begin display
.de DS
.RS
.nf
.sp
..
.\"	# DE - end display
.de DE
.fi
.RE
.sp
..
.\"	# SO - start of list of standard options
.de SO
'ie '\\$1'' .ds So \\fBoptions\\fR
'el .ds So \\fB\\$1\\fR
.SH "STANDARD OPTIONS"
.LP
.nf
.ta 5.5c 11c
.ft B
..
.\"	# SE - end of list of standard options
.de SE
.fi
.ft R
.LP
See the \\*(So manual entry for details on the standard options.
..
.\"	# OP - start of full description for a single option
.de OP
.LP
.nf
.ta 4c
Command-Line Name:	\\fB\\$1\\fR
Database Name:	\\fB\\$2\\fR
Database Class:	\\fB\\$3\\fR
.fi
.IP
..
.\"	# CS - begin code excerpt
.de CS
.RS
.nf
.ta .25i .5i .75i 1i
..
.\"	# CE - end code excerpt
.de CE
.fi
.RE
..
.\"	# UL - underline word
.de UL
\\$1\l'|0\(ul'\\$2
..
.\"	# QW - apply quotation marks to word
.de QW
.ie '\\*(lq'"' ``\\$1''\\$2
.\"" fix emacs highlighting
.el \\*(lq\\$1\\*(rq\\$2
..
.\"	# PQ - apply parens and quotation marks to word
.de PQ
.ie '\\*(lq'"' (``\\$1''\\$2)\\$3
.\"" fix emacs highlighting
.el (\\*(lq\\$1\\*(rq\\$2)\\$3
..
.\"	# QR - quoted range
.de QR
.ie '\\*(lq'"' ``\\$1''\\-``\\$2''\\$3
.\"" fix emacs highlighting
.el \\*(lq\\$1\\*(rq\\-\\*(lq\\$2\\*(rq\\$3
..
.\"	# MT - "empty" string
.de MT
.QW ""
..
.BS
.SH NAME
tar \- Tar file creation, extraction & manipulation
.SH SYNOPSIS
package require \fBTcl 8\&.5 9\fR
.sp
package require \fBtar ?0\&.14?\fR
.sp
\fB::tar::contents\fR \fItarball\fR ?\fB-chan\fR? ?\fB-gzip\fR?
.sp
\fB::tar::stat\fR \fItarball\fR ?file? ?\fB-chan\fR? ?\fB-gzip\fR?
.sp
\fB::tar::untar\fR \fItarball\fR \fIargs\fR
.sp
\fB::tar::get\fR \fItarball\fR \fIfileName\fR ?\fB-chan\fR? ?\fB-gzip\fR?
.sp
\fB::tar::create\fR \fItarball\fR \fIfiles\fR \fIargs\fR
.sp
\fB::tar::add\fR \fItarball\fR \fIfiles\fR \fIargs\fR
.sp
\fB::tar::remove\fR \fItarball\fR \fIfiles\fR
.sp
.BE
.SH DESCRIPTION
.PP
\fINote\fR: Starting with version 0\&.8 the tar reader commands
(contents, stats, get, untar) support the GNU LongName extension (header type
\'L') for large paths\&.
.PP
.SH BEWARE
For all commands, when using \fB-chan\fR \&.\&.\&.
.IP [1]
It is assumed that the channel was opened for reading, and configured for
binary input\&.
.IP [2]
It is assumed that the channel position is at the beginning of a legal
tar file\&.
.IP [3]
The commands will \fImodify\fR the channel position as they perform their
task\&.
.IP [4]
The commands will \fInot\fR close the channel\&.
.IP [5]
In other words, the commands leave the channel in a state very likely
unsuitable for use by further \fBtar\fR commands\&. Still doing so will
very likely results in errors, bad data, etc\&. pp\&.
.IP [6]
It is the responsibility of the user to seek the channel back to a
suitable position\&.
.IP [7]
When using a channel transformation which is not generally seekable, for
example \fBgunzip\fR, then it is the responsibility of the user to (a)
unstack the transformation before seeking the channel back to a suitable
position, and (b) for restacking it after\&.
.PP
Regarding support for gzip compression:
.IP [1]
Errors are thrown when attempting to read from compressed tar archives
while compression support (i\&.e\&. \fB::zlib\fR) is not available\&.
.IP [2]
Errors are thrown when attempting to read an uncompressed tar archive
when compression is requested by the user (\fB-gzip\fR)\&.
.sp
No errors are thrown when attempting to read a compressed tar archive
when compression was not requested, and is supported\&. In that case the
commands automatically activate the code handling the compression\&.
.IP [3]
Errors are thrown when attempting to edit compressed tar archives\&.
See the commands \fBtar::add\fR, and \fBtar::remove\fR\&.
This is not supported\&.
.IP [4]
Creation of compressed tar archives however is supported, as this
sequentially writes the archive, allowing for streaming compression\&.
.PP
.SH COMMANDS
.TP
\fB::tar::contents\fR \fItarball\fR ?\fB-chan\fR? ?\fB-gzip\fR?
Returns a list of the files contained in \fItarball\fR\&. The order is not sorted and depends on the order
files were stored in the archive\&.
.sp
If the option \fB-chan\fR is present \fItarball\fR is interpreted as an open channel\&.
It is assumed that the channel was opened for reading, and configured for binary input\&.
The command will \fInot\fR close the channel\&.
.TP
\fB::tar::stat\fR \fItarball\fR ?file? ?\fB-chan\fR? ?\fB-gzip\fR?
Returns a nested dict containing information on the named ?file? in \fItarball\fR,
or all files if none is specified\&. The top level are pairs of filename and info\&. The info is a dict with the keys
"\fBmode\fR \fBuid\fR \fBgid\fR \fBsize\fR \fBmtime\fR \fBtype\fR \fBlinkname\fR \fBuname\fR \fBgname\fR
\fBdevmajor\fR \fBdevminor\fR"
.CS


% ::tar::stat tarball\&.tar
foo\&.jpg {mode 0644 uid 1000 gid 0 size 7580 mtime 811903867 type file linkname {} uname user gname wheel devmajor 0 devminor 0}

.CE
.sp
If the option \fB-chan\fR is present \fItarball\fR is interpreted as an open channel\&.
It is assumed that the channel was opened for reading, and configured for binary input\&.
The command will \fInot\fR close the channel\&.
.TP
\fB::tar::untar\fR \fItarball\fR \fIargs\fR
Extracts \fItarball\fR\&. \fI-file\fR and \fI-glob\fR limit the extraction
to files which exactly match or pattern match the given argument\&. No error is
thrown if no files match\&. Returns a list of filenames extracted and the file
size\&. The size will be null for non regular files\&. Leading path seperators are
stripped so paths will always be relative\&.
.RS
.TP
\fB-dir\fR dirName
Directory to extract to\&. Uses \fBpwd\fR if none is specified
.TP
\fB-file\fR fileName
Only extract the file with this name\&. The name is matched against the complete path
stored in the archive including directories\&.
.TP
\fB-glob\fR pattern
Only extract files patching this glob style pattern\&. The pattern is matched against the complete path
stored in the archive\&.
.TP
\fB-nooverwrite\fR
Dont overwrite files that already exist
.TP
\fB-nomtime\fR
Leave the file modification time as the current time instead of setting it to the value in the archive\&.
.TP
\fB-noperms\fR
In Unix, leave the file permissions as the current umask instead of setting them to the values in the archive\&.
.TP
\fB-chan\fR
If this option is present \fItarball\fR is interpreted as an open channel\&.
It is assumed that the channel was opened for reading, and configured for binary input\&.
The command will \fInot\fR close the channel\&.
.RE
.sp
.CS


% foreach {file size} [::tar::untar tarball\&.tar -glob *\&.jpg] {
puts "Extracted $file ($size bytes)"
}

.CE
.TP
\fB::tar::get\fR \fItarball\fR \fIfileName\fR ?\fB-chan\fR? ?\fB-gzip\fR?
Returns the contents of \fIfileName\fR from the \fItarball\fR\&.
.sp
.CS


% set readme [::tar::get tarball\&.tar doc/README] {
% puts $readme
}

.CE
.sp
If the option \fB-chan\fR is present \fItarball\fR is
interpreted as an open channel\&.  It is assumed that the channel was
opened for reading, and configured for binary input\&.  The command will
\fInot\fR close the channel\&.
.sp
An error is thrown when \fIfileName\fR is not found in the tar
archive\&.
.TP
\fB::tar::create\fR \fItarball\fR \fIfiles\fR \fIargs\fR
Creates a new tar file containing the \fIfiles\fR\&. \fIfiles\fR must be specified
as a single argument which is a proper list of filenames\&.
.RS
.TP
\fB-dereference\fR
Normally \fBcreate\fR will store links as an actual link pointing at a file that may
or may not exist in the archive\&. Specifying this option will cause the actual file point to
by the link to be stored instead\&.
.TP
\fB-chan\fR
If this option is present \fItarball\fR is interpreted as an open channel\&.
It is assumed that the channel was opened for writing, and configured for binary output\&.
The command will \fInot\fR close the channel\&.
.RE
.sp
.CS


% ::tar::create new\&.tar [glob -nocomplain file*]
% ::tar::contents new\&.tar
file1 file2 file3

.CE
.TP
\fB::tar::add\fR \fItarball\fR \fIfiles\fR \fIargs\fR
Appends \fIfiles\fR to the end of the existing \fItarball\fR\&. \fIfiles\fR must be specified
as a single argument which is a proper list of filenames\&.
.RS
.TP
\fB-dereference\fR
Normally \fBadd\fR will store links as an actual link pointing at a file that may
or may not exist in the archive\&. Specifying this option will cause the actual file point to
by the link to be stored instead\&.
.TP
\fB-prefix\fR string
Normally \fBadd\fR will store files under exactly the name specified as
argument\&. Specifying a ?-prefix? causes the \fIstring\fR to be
prepended to every name\&.
.TP
\fB-quick\fR
The only sure way to find the position in the \fItarball\fR where new
files can be added is to read it from start, but if \fItarball\fR was
written with a "blocksize" of 1 (as this package does) then one can
alternatively find this position by seeking from the end\&. The
?-quick? option tells \fBadd\fR to do the latter\&.
.RE
.sp
.TP
\fB::tar::remove\fR \fItarball\fR \fIfiles\fR
Removes \fIfiles\fR from the \fItarball\fR\&. No error will result if the file does not exist in the
tarball\&. Directory write permission and free disk space equivalent to at least the size of the tarball
will be needed\&.
.CS


% ::tar::remove new\&.tar {file2 file3}
% ::tar::contents new\&.tar
file3

.CE
.PP
.SH "BUGS, IDEAS, FEEDBACK"
This document, and the package it describes, will undoubtedly contain
bugs and other problems\&.
Please report such in the category \fItar\fR of the
\fITcllib Trackers\fR [http://core\&.tcl\&.tk/tcllib/reportlist]\&.
Please also report any ideas for enhancements you may have for either
package and/or documentation\&.
.PP
When proposing code changes, please provide \fIunified diffs\fR,
i\&.e the output of \fBdiff -u\fR\&.
.PP
Note further that \fIattachments\fR are strongly preferred over
inlined patches\&. Attachments can be made by going to the \fBEdit\fR
form of the ticket immediately after its creation, and then using the
left-most button in the secondary navigation bar\&.
.SH KEYWORDS
archive, tape archive, tar
.SH CATEGORY
File formats
