[comment {-*- tcl -*- doctools manpage}]
[vset VERSION 0.4]
[manpage_begin math::filters n [vset VERSION]]
[keywords digital]
[keywords filtering]
[copyright {2020 by Arjen Markus}]
[moddesc   {Tcl Math Library}]
[titledesc {Digital filters}]
[category  Mathematics]
[require Tcl "8.6 9"]
[require TclOO]
[require math::filters [opt [vset VERSION]]]

[description]
[para]
The [package math::filters] package implements digital filters,
notably Butterworth and Chebyshev low-pass and high-pass filters. The procedures
allow to filter an entire data series as well as filter data one
by one.

Note: [uri https://en.wikipedia.org/wiki/Digital_filter] and other pages on Wikipedia describe
the principles and design considerations of these digital filters.

Note: This is a reimplementation compared to version 0.3, which was based on GPL-licensed code.
One possible incompatibility with that version is that the order now needs to be even.


[section "PROCEDURES"]

The package defines the following public procedures:

[list_begin definitions]

[call [cmd ::math::filters::filterButterworth] [arg lowpass] [arg order] [arg samplefreq] [arg cutofffreq]]

Determine the coefficients for a Butterworth filter of given (even) order. The coefficients are returned as
a nested list, suitable for the [term filter] command or method,

[list_begin arguments]
[arg_def bool lowpass] Generate a low-pass filter (1) or a high-pass filter (0)
[arg_def integer order] The order of the filter to be generated - it must be even
[arg_def double samplefreq] Sampling frequency of the data series
[arg_def double cutofffreq] Cut-off frequency for the filter (at most half the sampling frequency)
[list_end]


[call [cmd ::math::filters::filter] [arg coeffs] [arg data]]

Filter the entire data series based on the filter coefficients.

[list_begin arguments]
[arg_def list coeffs] List of coefficients as generated by [emph filterButterworth] (or in fact any similar list of coefficients)
[arg_def list data] Data to be filtered
[list_end]


[call [cmd ::math::filters::filterChebyshev] [arg lowpass] [arg order] [arg samplefreq] [arg cutofffreq] [opt [arg epsilon]]]

Determine the coefficients for a Chebyshev filter of given (even) order. The coefficients are returned as
a nested list, suitable for the [term filter] command or method, For this type of filters an extra parameter
can be given, the so-called ripple factor. This controls the smoothness of the gain factor.

[list_begin arguments]
[arg_def bool lowpass] Generate a low-pass filter (1) or a high-pass filter (0)
[arg_def integer order] The order of the filter to be generated - it must be even
[arg_def double samplefreq] Sampling frequency of the data series
[arg_def double cutofffreq] Cut-off frequency for the filter (must be less than half the sampling frequency)
[arg_def double epsilon] Ripple factor, defaults to 0.1
[list_end]


[call [cmd ::math::filters::filter] [arg coeffs] [arg data]]

Filter the entire data series based on the filter coefficients.

[list_begin arguments]
[arg_def list coeffs] List of coefficients as generated by [emph filterButterworth] (or in fact any similar list of coefficients)
[arg_def list data] Data to be filtered
[list_end]


[call [cmd ::math::filters::filterObject] new [arg coeffs] [arg yinit]]

Create a filter object. The initial x data are taken as zero. The initial y data can be prescribed. If they are not given,
they are taken as zero as well.

[list_begin arguments]
[arg_def list coeffs] List of coefficients as generated by [emph filterButterworth] (or in fact any similar list of coefficients)
[arg_def list yinit] (Optional) initial data for the filter result.
[list_end]


[call [cmd \$filterObj] filter [arg x]]

Filter a single value and return the result.

[list_begin arguments]
[arg_def double x] The value to be filtered
[list_end]


[call [cmd \$filterObj] reset]

Reset the filter object (start anew)

[list_end]

[manpage_end]
